/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.common.model.person;

import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;

/**
 * Represents summary information about a change/submit-for-change to a Person.
 * 
 * Created Apr 3, 2006 12:49:03 PM
 * 
 * @author DNS   BOHMEG
 */
public class PersonChangeLogEntry extends AbstractKeyedEntity {
	
    private static final long serialVersionUID = -5130281188920799457L;

    private Integer incomeYear;

	private Serializable personId;

	private String submitterDescription;

	private Date submittedDate = new Date();

	public PersonIdEntityKey getPersonEntityKey() {
		return personId != null ? CommonEntityKeyFactory.createPersonIdEntityKey(personId) : null;
	}
	
	public void setPersonEntityKey(PersonIdEntityKey key) {
		personId = key != null ? key.getPersonId() : null; 
	}

	/**
	 * @return Returns the incomeYear.
	 */
	public Integer getIncomeYear() {
		return incomeYear;
	}

	/**
	 * @param incomeYear
	 *            The incomeYear to set.
	 */
	public void setIncomeYear(Integer incomeYear) {
		this.incomeYear = incomeYear;
	}

	/**
	 * @return Returns the personId.
	 */
	private Serializable getPersonId() {
		return personId;
	}

	/**
	 * @param personId
	 *            The personId to set.
	 */
	private void setPersonId(Serializable personId) {
		this.personId = personId;
	}

	/**
	 * @return Returns the submittedDate.
	 */
	public Date getSubmittedDate() {
		return submittedDate;
	}

	/**
	 * @param submittedDate
	 *            The submittedDate to set.
	 */
	public void setSubmittedDate(Date submittedDate) {
		this.submittedDate = submittedDate;
	}

	/**
	 * @return Returns the submitterDescription.
	 */
	public String getSubmitterDescription() {
		return submitterDescription;
	}

	/**
	 * @param submitterDescription
	 *            The submitterDescription to set.
	 */
	public void setSubmitterDescription(String submitterDescription) {
		this.submitterDescription = submitterDescription;
	}
	
    protected void buildToString(ToStringBuilder builder) {
        builder.append("personId", this.personId);
        builder.append("submitterDescription", this.submitterDescription);        
        builder.append("incomeYear", this.incomeYear);        
        builder.append("submittedDate", this.submittedDate);
    }	
}
