package gov.va.med.esr.common.model.person;

import java.util.Date;

import gov.va.med.esr.common.model.lookup.TeamPurpose;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.fw.model.AbstractKeyedEntity;

import org.apache.commons.lang.builder.ToStringBuilder;

public class PatientProviderAssignmentLite extends AbstractKeyedEntity {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 2598564169111698497L;
	
    private PreferredFacilityPerson personLite = null;
    private HealthCareProvider provider = null;
    
    private Long teamId = null;
    private String teamName = null;
    private TeamPurpose teamPurpose = null;
    
    /* Provider Station Identifier - Facility associated with the Team 
     * assigned to patient. Reference to STD_INSTITUTION table.*/
    private VAFacility facility = null;
    
    private String patientId = null;
    
    /* Date Provider Assigned to Team Position at Assigning Facility. */
	private Date assignmentDate = null;
	
	/* Date Provider Un-Assigned from Team Position */
	private Date unassignmentDate = null;
 
	/**
	 * Creates a new PreferredFacility object.
	 */
	public PatientProviderAssignmentLite()
	{
	    super();
	}	
	
	/**
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder)
	{
	   super.buildToString(builder);
	   builder.append("teamId", this.teamId);
	   builder.append("teamName", this.teamName);
	   builder.append("teamPurpose", this.teamPurpose);
	   builder.append("patientId", this.patientId);
	   builder.append("assignmentDate", this.assignmentDate);
	   builder.append("unassignmentDate", this.unassignmentDate);
    }

	public Date getAssignmentDate() {
		return assignmentDate;
	}

	public void setAssignmentDate(Date assignmentDate) {
		this.assignmentDate = assignmentDate;
	}

	public PreferredFacilityPerson getPersonLite() {
		return personLite;
	}


	public void setPersonLite(PreferredFacilityPerson personLite) {
	    validateOwner(this.personLite, personLite);
		this.personLite = personLite;
	}

	public HealthCareProvider getProvider() {
		return provider;
	}


	public void setProvider(HealthCareProvider provider) {
		this.provider = provider;
	}

	public Long getTeamId() {
		return teamId;
	}


	public void setTeamId(Long teamId) {
		this.teamId = teamId;
	}


	public String getTeamName() {
		return teamName;
	}


	public void setTeamName(String teamName) {
		this.teamName = teamName;
	}


	public TeamPurpose getTeamPurpose() {
		return teamPurpose;
	}


	public void setTeamPurpose(TeamPurpose teamPurpose) {
		this.teamPurpose = teamPurpose;
	}


	public Date getUnassignmentDate() {
		return unassignmentDate;
	}


	public void setUnassignmentDate(Date unassignmentDate) {
		this.unassignmentDate = unassignmentDate;
	}


	public VAFacility getFacility() {
		return facility;
	}


	public void setFacility(VAFacility facility) {
		this.facility = facility;
	}

	public String getPatientId() {
		return patientId;
	}

	public void setPatientId(String patientId) {
		this.patientId = patientId;
	}
}
