package gov.va.med.esr.common.model.person;

// Java Classes

// Library Classes
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractEntity;

/**
 * @author Commons Team
 */
public class ICN
    extends AbstractEntity
{
    private static final long serialVersionUID = 3104071427659360822L;

    // The ICN value.
    private String value;

    // The ICN check sum value.
    private String checkSum;

    /**
     * Default constructor.
     */
    ICN()
    {
        super();
    }

    /**
     * Creates an ICN with the required elements.
     * 
     * @param value
     *        The ICN value.
     * @param checkSum
     *        The ICN check sum value.
     */
    public ICN(String value, String checkSum)
    {
        super();

        Validate.notNull(value, "The value is required (cannot be null).");
        Validate.notNull(checkSum, "The check sum is required (cannot be null).");
        
        this.value = value;
        this.checkSum = checkSum;
    }

    /**
     * Returns the ICN value.
     * 
     * @return The ICN value.
     */
    public String getValue()
    {
        return this.value;
    }

    /**
     * Sets the ICN value.
     * 
     * @param value
     *        The ICN value.
     */
    public void setValue(String value)
    {
        Validate.notNull(value, "The value is required (cannot be null).");
        this.value = value;
    }

    /**
     * Returns the ICN check sum value.
     * 
     * @return The ICN check sum value.
     */
    public String getCheckSum()
    {
        return this.checkSum;
    }

    /**
     * Sets the ICN check sum value.
     * 
     * @param checkSum
     *        The ICN check sum value.
     */
    public void setCheckSum(String checkSum)
    {
        Validate.notNull(checkSum, "The check sum is required (cannot be null).");
        this.checkSum = checkSum;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder)
    {
        builder
            .append("value", this.value)
            .append("checkSum", this.checkSum);
    }
}