package gov.va.med.esr.common.model.person;

import gov.va.med.fw.model.AbstractKeyedEntity;

import org.apache.commons.lang.builder.ToStringBuilder;

public class HealthCareProvider extends AbstractKeyedEntity {

	/**
	 * An instance of serialVersionUID
	 */

	private static final long serialVersionUID = -1664671693804287197L;
	private Name name = null;
	private String degree = null;

	/*This field corresponds to 1.1 & 1.2 of Provider ID of A08 ZPC segment: 
	 * Pointer to entry in NEW PERSON file (#200) & Facility Number
	 */
	private String practitionerId = null;
	
	    /**
	     * Creates a new PreferredFacility object.
	     */
	    public HealthCareProvider()
	    {
	        super();
	    }


	    /**
	     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	     */
	    protected void buildToString(ToStringBuilder builder)
	    {
	       super.buildToString(builder);
	       builder.append("name", this.name);
	       builder.append("degree", this.degree);
	       builder.append("practitionerId", this.practitionerId);
	    }

		public String getDegree() {
			return degree;
		}

		public void setDegree(String degree) {
			this.degree = degree;
		}

	   public Name getName() {
	        return name;
	    }

	    public void setName(Name name) {
	        this.name = name;
	    }


		public String getPractitionerId() {
			return practitionerId;
		}

		public void setPractitionerId(String practitionerId) {
			this.practitionerId = practitionerId;
		}
}
