package gov.va.med.esr.common.model.person;


// Library Classes
import org.apache.commons.lang.builder.ToStringBuilder;

// Framework Classes
import gov.va.med.fw.model.AbstractKeyedEntity;

// ESR Classes
import gov.va.med.esr.common.model.lookup.CollectionMethod;
import gov.va.med.esr.common.model.lookup.EthnicityType;

public class Ethnicity extends AbstractKeyedEntity
{     
    /**
     * 
     */
    private static final long serialVersionUID = 4873872865073321094L;
    /**
     * 
     */
 
    private Person person = null;
    private EthnicityType ethnicityType = null;
    private CollectionMethod collectionMethod = null;

    /**
     * Creates a new Name object.
     */
    public Ethnicity()
    {
        super();
    }

    public Person getPerson()
    {
        return person;
    }

    public void setPerson(Person person)
    {
        validateOwner(this.person, person);
        this.person = person;
    }


    public EthnicityType getEthnicityType() {
        return ethnicityType;
    }

    public void setEthnicityType(EthnicityType ethnicityType) {
        this.ethnicityType = ethnicityType;
    }

    /**
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder)
    {
       super.buildToString(builder);
       builder.append("ethnicityType", this.ethnicityType);
       builder.append("collectionMethod", this.collectionMethod);
    }
    
    public CollectionMethod getCollectionMethod() {
        return collectionMethod;
    }

    public void setCollectionMethod(CollectionMethod collectionMethod) {
        this.collectionMethod = collectionMethod;
    }
}
