package gov.va.med.esr.common.model.person;

import java.util.Date;

// Library Classes
import org.apache.commons.lang.builder.ToStringBuilder;

// Framework Classes
import gov.va.med.fw.model.AbstractKeyedEntity;

// ESR Classes
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.EmploymentStatus;
import gov.va.med.esr.common.model.party.Address;

public class Employment extends AbstractKeyedEntity
{     
    private static final long serialVersionUID = -4885736274751675940L;
 
    private Person person = null;
    private Spouse spouse = null;
    private EmploymentStatus employmentStatus = null;
    private String occupation = null;
    private String employerName = null;
    private Address employerAddress = null;
    private String employerPhone = null;
    // CCR 10673
    private ImpreciseDate retirementDate = null;
       
    /**
     * Creates a new Name object.
     */
    public Employment()
    {
        super();
    }

    public Person getPerson()
    {
        return person;
    }

    public void setPerson(Person person)
    {
        validateOwner(this.person, person);
        this.person = person;
    }

    public Spouse getSpouse() {
        return spouse;
    }

    public void setSpouse(Spouse spouse) {
        validateOwner(this.spouse, spouse);
       this.spouse = spouse;
    }

    public EmploymentStatus getEmploymentStatus() {
        return this.employmentStatus;
    }

     public void setEmploymentStatus(EmploymentStatus employmentStatus) {
        this.employmentStatus = employmentStatus;
     }

     public String getOccupation() {
         return occupation;
     }

     public void setOccupation(String occupation) {
         this.occupation = occupation;
     }
     
     public String getEmployerName() {
         return employerName;
     }

     public void setEmployerName(String employerName) {
         this.employerName = employerName;
     }
     
     public Address getEmployerAddress()
     {
         return employerAddress;
     }

     public void setEmployerAddress(Address employerAddress)
     {
         if (this.employerAddress != null)
         {
             this.employerAddress.setEmployment(null);
         }
         if (employerAddress != null)
         {
             employerAddress.setEmployment(this);
         }
         this.employerAddress = employerAddress;
     }
     
     public String getEmployerPhone()
     {
         return employerPhone;
     }

     public void setEmployerPhone(String employerPhone)
     {
         this.employerPhone = employerPhone;
     }

     // CCR 10673
     public ImpreciseDate getRetirementDate() {
         return retirementDate;
     }

     public void setRetirementDate(ImpreciseDate retirementDate) {
         this.retirementDate = retirementDate;
     }

     /**
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder)
    {
       super.buildToString(builder);
       
       builder.append("employmentStatus", this.employmentStatus);
       builder.append("occupation", this.occupation);
       builder.append("employerName", this.employerName);
       builder.append("employerPhone", this.employerPhone);
       builder.append("retirementDate", this.retirementDate);
    }
}
