/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Jan 24, 2006
 *
 */
package gov.va.med.esr.common.model.person;


// Java classes

// Library classes

// Framework classes
import java.util.Iterator;
import java.util.Set;

import org.apache.commons.lang.Validate;

import gov.va.med.fw.model.AbstractKeyedEntity;

// EDB Classes
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.EmergencyResponse;
import gov.va.med.esr.common.model.party.Address;

/**
 * @author Yi He
 * @version 1.0
 */
public class EmergencyResponseIndicator extends AbstractKeyedEntity {

	private static final long serialVersionUID = 8007649483937260092L;
    
    private EmergencyResponse emergencyResponse;
    private Person person;

    public EmergencyResponse getEmergencyResponse() {
    	return this.emergencyResponse;
    }
    
    public void setEmergencyResponse(EmergencyResponse emergencyResponse) {
        this.emergencyResponse = emergencyResponse;	
    }
    
    public Person getPerson() {
        return this.person;
    }
    
    public void setPerson(Person person) {
        validateOwner(this.person, person);
        this.person = person;
    }
    
    public static EmergencyResponseIndicator getEmergencyResponseIndicatorOfType(Set indicators, String typeCode) {
		Validate.notNull(indicators, "The set of EmergencyResponseIndicators must not be null");
		Validate.notNull(typeCode, "EmergencyResponse code must not be null");
		
        for (Iterator iter = indicators.iterator(); iter.hasNext();) {
            EmergencyResponseIndicator indicator = (EmergencyResponseIndicator) iter.next();
            EmergencyResponse type = indicator.getEmergencyResponse();
            if (type != null && type.getCode().equals(typeCode)) {
                return indicator;
            }
        }
        return null;
    }
    
}

