/*
 * DeathRecord.java
 * Copyright 2004,
 * Veterans Health Administration
 * All rights reserved.
 */

// Generated 11/26/2004 11:21:34 AM 
package gov.va.med.esr.common.model.person;

//----------------------------------------------------------------------------
//  Import java classes
//----------------------------------------------------------------------------
import java.sql.Timestamp;
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractEntity;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.DeathDataSource;
import gov.va.med.esr.common.model.lookup.VAFacility;

/**
 * 
 * 
 * @author Commons Team
 * @hibernate.class table=" "
 * 
 */

public class DeathRecord extends AbstractEntity {

	// ----------------------------------------------------------------------------
	// Static variable(s)
	// ----------------------------------------------------------------------------

	// ----------------------------------------------------------------------------
	// Static method(s)
	// ----------------------------------------------------------------------------

	// ----------------------------------------------------------------------------
	// Constructor(s)
	// ----------------------------------------------------------------------------

	private static final long serialVersionUID = -1943981675014069025L;

    /**
	 * Creates a new DeathRecord object.
	 */
	public DeathRecord() {
		super();
	}

	// ----------------------------------------------------------------------------
	// Public method(s)
	// ----------------------------------------------------------------------------

	/**
	 * Get the DeathDate attribute
	 * 
	 * @return The DeathDate instance variable.
	 * 
	 * @hibernate.property column=" "
	 */
	public ImpreciseDate getDeathDate() {
		return (deathDate);
	}

	/**
	 * Get the LazarusDate attribute
	 * 
	 * @return The LazarusDate instance variable.
	 * 
	 * @hibernate.property column=" "
	 */
	public ImpreciseDate getLazarusDate() {
		return (lazarusDate);
	}

	/**
	 * Get the DeathReportDate attribute
	 * 
	 * @return The DeathReportDate instance variable.
	 * 
	 * @hibernate.property column=" "
	 */
	public Date getDeathReportDate() {
		return (deathReportDate);
	}

	/**
	 * Get the DataSource attribute
	 * 
	 * @return The DataSource instance variable.
	 * 
	 * @hibernate.property column=" "
	 */
	public DeathDataSource getDataSource() {
		return (dataSource);
	}

	/**
	 * @return Returns the facilityReceived.
	 */
	public VAFacility getFacilityReceived() {
		return facilityReceived;
	}
	
	/**
	 * @param deathReportedBy
	 *            UI, Messagging or MVI service that reported to set.
	 */
	public String getDeathReportedBy() {
		return (deathReportedBy);		
	}

	public Boolean getDodVerifiedInd() {
		return dodVerifiedInd;
	}

	/**
	 * Set the DeathDate attribute
	 * 
	 * @param newDeathDate
	 *            The value to set the DeathDate instance variable to.
	 */
	public void setDeathDate(ImpreciseDate newDeathDate) {
		deathDate = newDeathDate;
		//setDeathLastUpdated();
	}

	/**
	 * Set the LazarusDate attribute
	 * 
	 * @param newLazarusDate
	 *            The value to set the LazarusDate instance variable to.
	 */
	public void setLazarusDate(ImpreciseDate newLazarusDate) {
		lazarusDate = newLazarusDate;
		//setDeathLastUpdated();
	}

	/**
	 * Set the DeathReportDate attribute
	 * 
	 * @param newDeathReportDate
	 *            The value to set the DeathReportDate instance variable to.
	 */
	public void setDeathReportDate(Date newDeathReportDate) {
		deathReportDate = newDeathReportDate;
		//setDeathLastUpdated();
	}

	/**
	 * Set the DataSource attribute
	 * 
	 * @param newDataSource
	 *            The value to set the DataSource instance variable to.
	 */
	public void setDataSource(DeathDataSource newDataSource) {
		dataSource = newDataSource;
		//setDeathLastUpdated();
	}

	/**
	 * @param facilityReceived
	 *            The facilityReceived to set.
	 */
	public void setFacilityReceived(VAFacility receivedFacility) {
		this.facilityReceived = receivedFacility;
		//setDeathLastUpdated();
	}

	private void setDeathLastUpdated() {
		setDeathLastModified(new Timestamp(System.currentTimeMillis()));
	} 
	
	/**
	 * @param deathReportedBy
	 *            UI, Messagging or MVI service that reported to set.
	 */
	public void setDeathReportedBy(String deathReportedBy) {
		this.deathReportedBy = deathReportedBy;		
	}
	
	public void setDodVerifiedInd(Boolean dodVerifiedInd) {
		this.dodVerifiedInd = dodVerifiedInd;
	}


	protected void buildToString(ToStringBuilder builder) {
		builder.append("deathDate", this.deathDate);
		builder.append("lazarusDate", this.lazarusDate);
		builder.append("deathReportDate", this.deathReportDate);
		builder.append("dataSource", this.dataSource);
		builder.append("facilityReceived", this.facilityReceived);
		builder.append("deathLastModified", this.deathLastModified);		
	}


	/**
	 * Date of death is defined as the deceased date for the individual. DOD
	 * cannot be in the future and DOD cannot be prior to Date of birth
	 */
	private ImpreciseDate deathDate = null;

	/**
	 * Lazarus date is defined as the date the date of death was removed via a
	 * Lazarus transmission
	 */
	private ImpreciseDate lazarusDate = null;

	/**
	 * Date of Death report date is defined as the date that the DOD is reported
	 * or updated.Maps to Reeme date of death last updated
	 */
	private Date deathReportDate = null;

	/**
	 * Source of notification is defined as the source of the DOD being added or
	 * source of DOD removal. The acceptable choices are: 1 Next of
	 * Kin/Family/Friend 2 Inpatient at VAMC 3 VBA 4 VA Insurance 5 NCA 6 SSA 7
	 * Entered in Error 8 Other
	 */
	private DeathDataSource dataSource = null;

	/**
	 * Site that sent the death data
	 */
	private VAFacility facilityReceived = null;

	private Timestamp deathLastModified; // keep separate from audit columns

	// as this has business meaning
	
	private String deathReportedBy = null;
	
	private Boolean dodVerifiedInd = null;


	/**
	 * @return Returns the deathLastModified.
	 */
	public Timestamp getDeathLastModified() {
		return deathLastModified;
	}

	/**
	 * @param deathLastModified
	 *            The deathLastModified to set.
	 */
	private void setDeathLastModified(Timestamp deathLastModified) {
		this.deathLastModified = deathLastModified;
	}

} // End of DeathRecord Class

