/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.person;

//----------------------------------------------------------------------------
//  Import java classes
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
//  Import third party library classes
//----------------------------------------------------------------------------
import org.apache.commons.lang.builder.ToStringBuilder;

//----------------------------------------------------------------------------
//  Import Framework classes
//----------------------------------------------------------------------------
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.esr.common.infra.ImpreciseDate;

/**
 * @author Commons Team
 * @version 1.0
 */
public class BirthRecord extends AbstractEntity {
    /**
	 * 
	 */
	private static final long serialVersionUID = -7263166970710124994L;
	private ImpreciseDate birthDate = null;
    private String city = null;
    private String state = null;
    private String country = null;
    private Boolean multipleBirth = null;

    //----------------------------------------------------------------------------
    // Constructor(s)
    //----------------------------------------------------------------------------
    /**
     * Creates a new BirthRecord object.
     */
    public BirthRecord() {
        super();
    }

    //----------------------------------------------------------------------------
    // Public method(s)
    //----------------------------------------------------------------------------
    /**
     * Get the BirthDate attribute
     * 
     * @return The BirthDate instance variable.
     * 
     * @hibernate.property column=" "
     */
    public ImpreciseDate getBirthDate() {
        return (birthDate);
    }

    /**
     * Get the City attribute
     * 
     * @return The City instance variable.
     * 
     * @hibernate.property column=" "
     */
    public String getCity() {
        return (city);
    }

    /**
     * Get the State attribute
     * 
     * @return The State instance variable.
     * 
     * @hibernate.property column=" "
     */
    public String getState() {
        return (state);
    }

    /**
     * Get the Country attribute
     * 
     * @return The Country instance variable.
     * 
     * @hibernate.property column=" "
     */
    public String getCountry() {
        return (country);
    }

    /**
     * Set the BirthDate attribute
     * 
     * @param newBirthDate
     *            The value to set the BirthDate instance variable to.
     */
    public void setBirthDate(ImpreciseDate newBirthDate) {
        birthDate = newBirthDate;
    }

    /**
     * Set the City attribute
     * 
     * @param newCity
     *            The value to set the City instance variable to.
     */
    public void setCity(String newCity) {
        city = newCity;
    }

    /**
     * Set the State attribute
     * 
     * @param newState
     *            The value to set the State instance variable to.
     */
    public void setState(String newState) {
        state = newState;
    }

    /**
     * Set the Country attribute
     * 
     * @param newCountry
     *            The value to set the Country instance variable to.
     */
    public void setCountry(String newCountry) {
        country = newCountry;
    }


    public Boolean getMultipleBirth() {
        return multipleBirth;
    }

    public Boolean isMultipleBirth() {
        return multipleBirth;
    }

    public void setMultipleBirth(Boolean multipleBirth) {
        this.multipleBirth = multipleBirth;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder) {
        builder.append("birthDate", this.birthDate == null ? null : this.birthDate.getDate());
        builder.append("city", this.city);
        builder.append("state", this.state);
        builder.append("country", this.country);
        builder.append("multipleBirth", this.multipleBirth);
    }

}
