/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on May 23, 2006
 *
 */
package gov.va.med.esr.common.model.party;

// Java classes

// Library classes
import org.apache.commons.lang.builder.ToStringBuilder;

// Framework classes
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.EntityKey;

// EDB Classes
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.lookup.ConfidentialAddressCategoryType;

/**
 * @author Yi He
 * @version 1.0
 */
public class ConfidentialAddressCategory extends AbstractKeyedEntity {

    private static final long serialVersionUID = -6394596998078285029L;
    
    private Person person = null;
	private ConfidentialAddressCategoryType type = null;

	public ConfidentialAddressCategoryType getType() {
		return this.type;		
	}
	
	public void setType(ConfidentialAddressCategoryType type) {
		this.type = type;
	}
	
    public void setPerson(Person person) 
    {
        validateOwner(this.person, person);
        this.person = person;
    }
    
    public Person getPerson() {
        return person;
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder)
    {
        super.buildToString(builder);

        builder.append("type", this.type);
   }	
}