/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.common.model.messaging;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.fw.model.AbstractEntity;

/**
 * Allows for passing a single object to aggregate site identities.
 * 
 * Created Sep 28, 2006 11:18:27 AM
 * 
 * @author DNS   BOHMEG
 */
public class SiteIdentityGroup extends AbstractEntity {
	private static final long serialVersionUID = 8859472104239250472L;

    private PersonEntityKey personKey;

	private Set internalSiteIdentities;

	private boolean consistencyCheckCaseCreated;

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		Integer size = internalSiteIdentities != null ? new Integer(internalSiteIdentities
				.size()) : new Integer(0);
		builder.append("personKey", personKey);
		builder.append("numSites", size);
		builder.append("consistencyCheckCaseCreated",
				consistencyCheckCaseCreated);
	}

	public void addSiteIdentity(SiteIdentity site) {
		Validate.notNull(site, "Null site specified.");
		getInternalSiteIdentities().add(site);
		site.setGroup(this);
	}

	private Set getInternalSiteIdentities() {
		if (internalSiteIdentities == null) {
			this.internalSiteIdentities = new HashSet();
		}
		return this.internalSiteIdentities;
	}

	/**
	 * @param internalSiteIdentities The internalSiteIdentities to set.
	 */
	public Set getSiteIdentities() {
		return Collections.unmodifiableSet(getInternalSiteIdentities());		
	}
	
	/**
	 * @return Returns the consistencyCheckCaseCreated.
	 */
	public boolean isConsistencyCheckCaseCreated() {
		return consistencyCheckCaseCreated;
	}

	/**
	 * @param consistencyCheckCaseCreated
	 *            The consistencyCheckCaseCreated to set.
	 */
	public void setConsistencyCheckCaseCreated(
			boolean consistencyCheckCaseCreated) {
		this.consistencyCheckCaseCreated = consistencyCheckCaseCreated;
	}

	/**
	 * @return Returns the personKey.
	 */
	public PersonEntityKey getPersonKey() {
		return personKey;
	}

	/**
	 * @param personKey
	 *            The personKey to set.
	 */
	public void setPersonKey(PersonEntityKey personKey) {
		this.personKey = personKey;
	}
}
