/*
 * SiteIdentity.java
 * Copyright 2004,
 * Veterans Health Administration
 * All rights reserved.
 */

// Generated 11/26/2004 10:22:32 AM 
package gov.va.med.esr.common.model.messaging;

//----------------------------------------------------------------------------
//  Import java classes
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
//  Import third party library classes
//----------------------------------------------------------------------------
import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;

/**
 * 
 * 
 * @author Commons Team
 * @hibernate.mapping auto-import="true" default-cascade="all"
 * @hibernate.class table="SITE_IDENTITY"
 * 
 */

public class SiteIdentity extends AbstractKeyedEntity { 

	// ----------------------------------------------------------------------------
	// Static variable(s)
	// ----------------------------------------------------------------------------

	// ----------------------------------------------------------------------------
	// Static method(s)
	// ----------------------------------------------------------------------------

	// ----------------------------------------------------------------------------
	// Constructor(s)
	// ----------------------------------------------------------------------------

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 964966795378617361L;

	/**
	 * Creates a new SiteIdentity object.
	 */
	public SiteIdentity() {
		super();
	}

	// ----------------------------------------------------------------------------
	// Public method(s)
	// ----------------------------------------------------------------------------

	public String getDfn() {
		return this.dfn;
	}

	public void setDfn(String dfn) {
		this.dfn = dfn;
	}

	public Person getPerson() {
		return this.person;
	}

	public void setPerson(Person person) {
		this.person = person;
	}

	public VAFacility getVaFacility() {
		return this.vaFacility;
	}

	public void setVaFacility(VAFacility vaFacility) {
		this.vaFacility = vaFacility;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);

		builder.append("dfn", this.dfn);
		// builder.append("person", this.person);
		// builder.append("vaFacility", this.vaFacility);
	}

	/**
	 * @hibernate.property insert="true" update="true" column="IEN" length="20"
	 */
	private String dfn = null;

	/**
	 * @hibernate.many-to-one class="gov.va.med.esr.common.model.person.Person"
	 *                        cascade="none" not-null="true" insert="true"
	 *                        update="true"
	 * @hibernate.column name="PARTY_ID"
	 */
	private Person person = null;

	/**
	 * @hibernate.many-to-one class="gov.va.med.esr.common.model.party.VAFacility"
	 *                        cascade="none" not-null="true" insert="true"
	 *                        update="true"
	 * @hibernate.column name="RECORD_ORIGIN_ID"
	 */
	private VAFacility vaFacility = null;
	
	private SiteIdentityGroup group;

	/**
	 * @return Returns the group.
	 */
	public SiteIdentityGroup getGroup() {
		return group;
	}

	/**
	 * @param group The group to set.
	 */
	public void setGroup(SiteIdentityGroup group) {
		this.group = group;
	}

} // End of SiteIdentity Class

