/*******************************************************************************
 * Copyright  2004-2005 EDS. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.messaging;

// ----------------------------------------------------------------------------
// Import java classes
// ----------------------------------------------------------------------------

import java.math.BigDecimal;

import gov.va.med.esr.common.model.lookup.SeedStatus;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.fw.model.AbstractKeyedEntity;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author Commons Team
 * @hibernate.mapping auto-import="true" default-cascade="all"
 * @hibernate.class table="MESSAGES"
 */

public class SeedingLogEntry extends AbstractKeyedEntity {

    private static final long serialVersionUID = -6712396040378523357L;
	
	private BigDecimal personId = null;	
	
	private String originatingProcess = null;
	
	private VAFacility vaFacility = null;	
	
	private BigDecimal recordModifiedCount = null;	
	
	
	/**
	 * @hibernate.many-to-one class="gov.va.med.esr.common.model.lookup.SeedingStatus"
	 *                        cascade="none" not-null="true" insert="true"
	 *                        update="true"
	 * @hibernate.column name="STATUS_ID"
	 */
	private SeedStatus status = null;	
    
	
	
	/**
	 * Creates a new Message object.
	 */
	public SeedingLogEntry() {
		super();
	}

	// ----------------------------------------------------------------------------
	// Public method(s)
	// ----------------------------------------------------------------------------

	public SeedStatus getStatus() {
		return this.status;
	}

	public void setStatus(SeedStatus status) {
		this.status = status;
	}
	
	public String getOriginatingProcess() {
		return this.originatingProcess;
	}

	public void setOriginatingProcess(String originatingProcess) {
		this.originatingProcess = originatingProcess;
	}
	
    /**
     * @return Returns the personId.
     */
    public BigDecimal getPersonId()
    {
        return personId;
    }
    /**
     * @param personId The personId to set.
     */
    public void setPersonId(BigDecimal personId)
    {
        this.personId = personId;
    }
    
    public VAFacility getVaFacility() {
        return vaFacility;
    }

    public void setVaFacility(VAFacility vaFacility) {
    	this.vaFacility = vaFacility;
    }
    
	/**
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);

		builder.append("errorText", this.status.getDescription());
	}
} // End of Message Class