/*******************************************************************************
 * Copyright  2004-2005 EDS. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.messaging;

// ----------------------------------------------------------------------------
// Import java classes
// ----------------------------------------------------------------------------

import gov.va.med.fw.model.AbstractKeyedEntity;

import java.math.BigDecimal;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author Commons Team
 * @hibernate.mapping auto-import="true" default-cascade="all"
 * @hibernate.class table="MESSAGES"
 */

public class MsdsMessagePayloadEntry extends AbstractKeyedEntity {

    private static final long serialVersionUID = -6712396040378523357L;

	private String request = null;

	private String response = null;

	private BigDecimal msdsMessageLogId = null;
	
	/**
	 * Creates a new Message object.
	 */
	public MsdsMessagePayloadEntry() {
		super();
	}

	// ----------------------------------------------------------------------------
	// Public method(s)
	// ----------------------------------------------------------------------------

	public BigDecimal getMsdsMessageLogId() {
		return this.msdsMessageLogId;
	}

	public void setMsdsMessageLogId(BigDecimal msdsMessageLogId) {
		this.msdsMessageLogId = msdsMessageLogId;
	}
	
	public String getRequest() {
		return this.request;
	}
	public void setRequest(String request) {
		this.request = request;
	}
	
	public String getResponse() {
		return this.response;
	}
	public void setResponse(String response) {
		this.response = response;
	}
	
	/**
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);

		builder.append("request", this.request);
		builder.append("response", this.response);
	}
} // End of Message Class