/*******************************************************************************
 * Copyright  2004-2005 EDS. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.messaging;

// ----------------------------------------------------------------------------
// Import java classes
// ----------------------------------------------------------------------------

import gov.va.med.esr.common.model.lookup.MessageStatus;
import gov.va.med.fw.model.AbstractKeyedEntity;
import java.math.BigDecimal;
import java.util.Date;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;



/**
 * @author Commons Team
 * @hibernate.mapping auto-import="true" default-cascade="all"
 * @hibernate.class table="MESSAGES"
 */

public class MsdsMessageLogEntry extends AbstractKeyedEntity {

    private static final long serialVersionUID = -6712396040378523357L;		

	private MsdsErrorLogEntry msdsError = null;		

	private BigDecimal personId = null;    
	
	private BigDecimal controlIdentifier = null;
	
	private Date transmissionDate = null;
	
	private MessageStatus status = null;
	
	private int transmissionCount;
	
	private String transmissionInfo = null;
	
	
	public String getTransmissionInfo() {
		return transmissionInfo;
	}

	public void setTransmissionInfo(String transmissionInfo) {
		this.transmissionInfo = transmissionInfo;
	}

	/**
	 * Creates a new Message object.
	 */
	public MsdsMessageLogEntry() {
		super();
	}

	// ----------------------------------------------------------------------------
	// Public method(s)
	// ----------------------------------------------------------------------------	
	
    /**
     * @return Returns the personId.
     */
    public BigDecimal getPersonId()
    {
        return personId;
    }
    /**
     * @param personId The personId to set.
     */
    public void setPersonId(BigDecimal personId)
    {
        this.personId = personId;
    }
    
    public BigDecimal getControlIdentifier() {
		return this.controlIdentifier;
	}

	public void setControlIdentifier(BigDecimal controlIdentifier) {
		this.controlIdentifier = controlIdentifier;
	}
	
	public MessageStatus getStatus() {
		return this.status;
	}

	public void setStatus(MessageStatus status) {
		this.status = status;
	}
	
	public MsdsErrorLogEntry getMsdsError() {
		return this.msdsError;
	}

	public void setMsdsError(MsdsErrorLogEntry msdsError) {
		this.msdsError = msdsError;
	}
	
	public int getTransmissionCount() {
		return this.transmissionCount;
	}

	public void setTransmissionCount(int transmissionCount) {
		this.transmissionCount = transmissionCount;
	}
	
	public Date getTransmissionDate() {
		return this.transmissionDate;
	}

	public void setTransmissionDate(Date transmissionDate) {
		this.transmissionDate = transmissionDate;
	}
	
	/**
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);

		if (this.msdsError != null && StringUtils.isNotEmpty(this.msdsError.getErrorText())) {
			builder.append("errorText", this.msdsError.getErrorText());
		}
	}
} // End of Message Class