/*******************************************************************************
 * Copyright  2004-2005 EDS. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.messaging;

// ----------------------------------------------------------------------------
// Import java classes
// ----------------------------------------------------------------------------

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;

import java.math.BigDecimal;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author Commons Team
 * @hibernate.mapping auto-import="true" default-cascade="all"
 * @hibernate.class table="MESSAGES"
 */

public class MessageLogEntryLite extends AbstractMessageLogEntry {

    private static final long serialVersionUID = 2781508129079581746L;

	private BigDecimal personId = null;

	/**
	 * Creates a new Message object.
	 */
	public MessageLogEntryLite() {
		super();
	}

	// ----------------------------------------------------------------------------
	// Public method(s)
	// ----------------------------------------------------------------------------

    public PersonIdEntityKey getPersonIdEntityKey() {
        
        return (this.personId != null) ? CommonEntityKeyFactory.createPersonIdEntityKey(this.personId.toString()) : null;
    }

	private BigDecimal getPersonId() {
		return this.personId;
	}

	private void setPersonId(BigDecimal personId) {
		this.personId = personId;
	}
    
	/**
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);

		builder.append("personId", this.personId);
	}
} // End of Message Class