
package gov.va.med.esr.common.model.messaging;

// ----------------------------------------------------------------------------
// Import java classes
// ----------------------------------------------------------------------------

import gov.va.med.esr.common.model.lookup.TransmissionStatus;
import gov.va.med.fw.model.AbstractKeyedEntity;
import java.util.Date;
import java.util.Set;

import org.apache.commons.lang.builder.ToStringBuilder;



public class IrsTransmissionLogEntry extends AbstractKeyedEntity {

    private static final long serialVersionUID = -6712396040382523357L;

	private String receiptId;

	private Date transmissionDate;

	private Set<IrsTransmissionLogData> irsTransmissionLogData;

	private Set<IrsTransmissionLogDetailEntry> irsTransmissionLogDetails;

	private String batchTypeInd;

	private String taxYear;

	private String correctionInd;

	private Date ackDate;

	private String ackId;

	private String errorDescription;

	private TransmissionStatus transmissionStatus;



	public IrsTransmissionLogEntry() {
		super();
	}

	// ----------------------------------------------------------------------------
	// Public method(s)
	// ----------------------------------------------------------------------------


	/**
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
	}

	public String getReceiptId() {
		return receiptId;
	}

	public void setReceiptId(String receiptId) {
		this.receiptId = receiptId;
	}

	public String getBatchTypeInd() {
		return batchTypeInd;
	}

	public void setBatchTypeInd(String batchTypeInd) {
		this.batchTypeInd = batchTypeInd;
	}

	public String getTaxYear() {
		return taxYear;
	}

	public void setTaxYear(String taxYear) {
		this.taxYear = taxYear;
	}

	public String getCorrectionInd() {
		return correctionInd;
	}

	public void setCorrectionInd(String correctionInd) {
		this.correctionInd = correctionInd;
	}

	public Date getAckDate() {
		return ackDate;
	}

	public void setAckDate(Date ackDate) {
		this.ackDate = ackDate;
	}

	public String getAckId() {
		return ackId;
	}

	public void setAckId(String ackId) {
		this.ackId = ackId;
	}

	public String getErrorDescription() {
		return errorDescription;
	}

	public void setErrorDescription(String errorDescription) {
		this.errorDescription = errorDescription;
	}

	public Date getTransmissionDate() {
		return transmissionDate;
	}

	public void setTransmissionDate(Date transmissionDate) {
		this.transmissionDate = transmissionDate;
	}

	public TransmissionStatus getTransmissionStatus() {
		return transmissionStatus;
	}

	public void setTransmissionStatus(TransmissionStatus transmissionStatus) {
		this.transmissionStatus = transmissionStatus;
	}

	public Set<IrsTransmissionLogData> getIrsTransmissionLogData() {
		return irsTransmissionLogData;
	}

	public void setIrsTransmissionLogData(
			Set<IrsTransmissionLogData> irsTransmissionLogData) {
		this.irsTransmissionLogData = irsTransmissionLogData;
	}

	public Set<IrsTransmissionLogDetailEntry> getIrsTransmissionLogDetails() {
		return irsTransmissionLogDetails;
	}

	public void setIrsTransmissionLogDetails(
			Set<IrsTransmissionLogDetailEntry> irsTransmissionLogDetails) {
		this.irsTransmissionLogDetails = irsTransmissionLogDetails;
	}

}