
package gov.va.med.esr.common.model.messaging;

// ----------------------------------------------------------------------------
// Import java classes
// ----------------------------------------------------------------------------

import gov.va.med.esr.common.model.ee.IRS1095B;
import gov.va.med.fw.model.AbstractKeyedEntity;

import java.math.BigDecimal;
import org.apache.commons.lang.builder.ToStringBuilder;



public class IrsTransmissionLogDetailEntry extends AbstractKeyedEntity {

    private static final long serialVersionUID = -6712396040335023357L;

	private IrsTransmissionLogEntry batchTransmissionEntry;

    private String ien;

	private BigDecimal personId;

	private String id;

	private int recordSequence;

	private String errorDescription;

	private IRS1095B submittedData;

	private String status;


	public IrsTransmissionLogDetailEntry() {

		super();
		submittedData = new IRS1095B();

	}

	// ----------------------------------------------------------------------------
	// Public method(s)
	// ----------------------------------------------------------------------------


	/**
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
	}

	public IrsTransmissionLogEntry getBatchTransmissionEntry() {
		return batchTransmissionEntry;
	}

	public void setBatchTransmissionEntry(
			IrsTransmissionLogEntry batchTransmissionEntry) {
		this.batchTransmissionEntry = batchTransmissionEntry;
	}

	public String getIen() {
		return ien;
	}

	public void setIen(String ien) {
		this.ien = ien;
	}

	public BigDecimal getPersonId() {
		return personId;
	}

	public void setPersonId(BigDecimal personId) {
		this.personId = personId;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public int getRecordSequence() {
		return recordSequence;
	}

	public void setRecordSequence(int recordSequence) {
		this.recordSequence = recordSequence;
	}

	public String getErrorDescription() {

		return errorDescription;
	}

	public void setErrorDescription(String errorDescription) {
		this.errorDescription = errorDescription;
	}

	public IRS1095B getSubmittedData() {
		return submittedData;
	}

	public void setSubmittedData(IRS1095B submittedData) {
		this.submittedData = submittedData;
	}

	public String getStatus() {
		if (this.errorDescription != null && this.errorDescription.length() > 0) {
			return "Rejected"; //TODO
		} else if (this.batchTransmissionEntry.getTransmissionStatus().getName().equalsIgnoreCase("Accepted with Errors")) {
			return "Accepted";
		} else if (this.batchTransmissionEntry.getTransmissionStatus().getName().equalsIgnoreCase("Rejected")) {
			return "Batch Transmission Reject";
		}

		return this.batchTransmissionEntry.getTransmissionStatus().getName();
	}

	public void setStatus(String status) {
		this.status = status;
	}


}