
package gov.va.med.esr.common.model.messaging;

// ----------------------------------------------------------------------------
// Import java classes
// ----------------------------------------------------------------------------

import java.util.List;

import gov.va.med.esr.common.model.ee.IRS1095B;
import gov.va.med.esr.common.model.ee.IRSErrorMessageDetail;
import gov.va.med.fw.model.AbstractKeyedEntity;

import org.apache.commons.lang.builder.ToStringBuilder;



public class IrsTransmissionLogData extends AbstractKeyedEntity {

    private static final long serialVersionUID = -6712396330382523357L;

    private String requestData = null;

    private String responseData = null;

    private List<IRS1095B> requestDataList = null;

    private List<IRSErrorMessageDetail> responseDataList= null;

    private IrsTransmissionLogEntry batchTransmissionEntry;



	public IrsTransmissionLogData() {
		super();
	}

	// ----------------------------------------------------------------------------
	// Public method(s)
	// ----------------------------------------------------------------------------


	/**
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
	}

	public String getRequestData() {

		return requestData;

	}

	public void setRequestData(String requestData) {
		this.requestData = requestData;
	}

	public String getResponseData() {
		return responseData;
	}

	public void setResponseData(String responseData) {
		this.responseData = responseData;
	}

	public List<IRS1095B> getRequestDataList() {
		return requestDataList;
	}

	public void setRequestDataList(List<IRS1095B> requestDataList) {
		this.requestDataList = requestDataList;
	}

	public List<IRSErrorMessageDetail> getResponseDataList() {
		return responseDataList;
	}

	public void setResponseDataList(List<IRSErrorMessageDetail> responseDataList) {
		this.responseDataList = responseDataList;
	}

	public IrsTransmissionLogEntry getBatchTransmissionEntry() {
		return batchTransmissionEntry;
	}

	public void setBatchTransmissionEntry(
			IrsTransmissionLogEntry batchTransmissionEntry) {
		this.batchTransmissionEntry = batchTransmissionEntry;
	}


}