/*******************************************************************************
 * Copyright  2004-2005 EDS. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.messaging;

// ----------------------------------------------------------------------------
// Import java classes
// ----------------------------------------------------------------------------

import java.math.BigDecimal;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author Commons Team
 * @hibernate.mapping auto-import="true" default-cascade="all"
 * @hibernate.class table="MESSAGES"
 */

public class ArchivedMessageLogEntry extends AbstractMessageLogEntry {

    private static final long serialVersionUID = -6712396040378523357L;

	private String body = null;

	private String formattedBody = null;

	private String errorText = null;

	private String internalErrorText = null;

	private ArchivedMessageLogEntry initiatingMessage = null;

	private BigDecimal personId = null;
    
	private String retransmissionInfo = null;
	
	/**
	 * Creates a new Message object.
	 */
	public ArchivedMessageLogEntry() {
		super();
	}

	// ----------------------------------------------------------------------------
	// Public method(s)
	// ----------------------------------------------------------------------------

	public String getBody() {
		return this.body;
	}

	public void setBody(String body) {
		this.body = body;
	}

	public String getFormattedBody() {
		return this.formattedBody;
	}

	public void setFormattedBody(String formattedBody) {
		this.formattedBody = formattedBody;
	}

	public String getErrorText() {
		return this.errorText;
	}

	public void setErrorText(String errorText) {
		this.errorText = errorText;
	}

	public String getInternalErrorText() {
		return this.internalErrorText;
	}

	public void setInternalErrorText(String internalErrorText) {
		this.internalErrorText = internalErrorText;
	}


	public ArchivedMessageLogEntry getInitiatingMessage() {
		return this.initiatingMessage;
	}

	public void setInitiatingMessage(ArchivedMessageLogEntry initiatingMessage) {
		this.initiatingMessage = initiatingMessage;
	}

	public String getRetransmissionInfo() {
		return this.retransmissionInfo;
	}
	
	public void setRetransmissionInfo(String retransmissionInfo) {
		this.retransmissionInfo = retransmissionInfo;
	}
	
    /**
     * @return Returns the personId.
     */
    public BigDecimal getPersonId()
    {
        return personId;
    }
    /**
     * @param personId The personId to set.
     */
    public void setPersonId(BigDecimal personId)
    {
        this.personId = personId;
    }
	/**
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);

		builder.append("errorText", this.errorText);
	}
} // End of Message Class