/*******************************************************************************
 * Copyright  2004-2005 EDS. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.messaging;

// ----------------------------------------------------------------------------
// Import java classes
// ----------------------------------------------------------------------------
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.lookup.AckType;
import gov.va.med.esr.common.model.lookup.MessageStatus;
import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.lookup.VAFacility;

/**
 * @author Commons Team
 * @hibernate.mapping auto-import="true" default-cascade="all"
 * @hibernate.class table="MESSAGES"
 */

public abstract class AbstractMessageLogEntry extends AbstractKeyedEntity {

    private static final long serialVersionUID = -2961528379977011213L;

    /**
	 * @hibernate.property not-null="true" insert="true" update="true"
	 *                     column="MESSAGE_CONTROL_NUMBER" length="20"
	 */
	private String controlIdentifier = null;

	/**
	 * @hibernate.property insert="true" update="true"
	 *                     column="BATCH_CONTROL_NUMBER" length="20"
	 */
	private String batchControlIdentifier = null;

	/**
	 * @hibernate.many-to-one class="gov.va.med.esr.common.model.lookup.MessageType"
	 *                        cascade="none" not-null="true" insert="true"
	 *                        update="true"
	 * @hibernate.column name="MESSAGE_TYPE_ID"
	 */
	private MessageType type = null;

	/**
	 * @hibernate.property insert="true" update="true" column="TRANSMISSION_DATE"
	 */
	private Date transmissionDate = null;

	/**
	 * @hibernate.many-to-one class="gov.va.med.esr.common.model.lookup.MessageStatus"
	 *                        cascade="none" not-null="true" insert="true"
	 *                        update="true"
	 * @hibernate.column name="STATUS_ID"
	 */
	private MessageStatus status = null;

	/**
	 * @hibernate.property insert="true" update="true" column="ACK_DATE"
	 */
	private Date ackDate = null;

	/**
	 * @hibernate.property insert="true" update="true" column="ACK_TYPE"
	 *                     length="2"
	 */
	private AckType ackType = null;

	/**
	 * @hibernate.property insert="true" update="true" column="ERROR_TEXT"
	 *                     length="2000"
	 */
	private String errorText = null;

	/**
	 * @hibernate.property insert="true" update="true"
	 *                     column="INTERNAL_ERROR_TEXT"
	 */
	private String internalErrorText = null;

	/**
	 * @hibernate.many-to-one class="gov.va.med.esr.common.model.party.VAFacility"
	 *                        cascade="none" insert="true" update="true"
	 * @hibernate.column name="RECORD_ORIGIN_ID"
	 */
	private VAFacility vaFacility = null;

	/**
	 * @hibernate.property not-null="true" insert="true" update="true"
	 *                     column="RETRANSMISSION_COUNT"
	 */
	private int retransmissionCount;

	/**
	 * @hibernate.property insert="true" update="true" column="SITE_RECORD_ELGBTY_STATUS_CODE"
	 */
	private String siteReceivedEligibilityStatus = null;

	/**
	 * Creates a new Message object.
	 */
	public AbstractMessageLogEntry() {
		super();
	}

	// ----------------------------------------------------------------------------
	// Public method(s)
	// ----------------------------------------------------------------------------

	public String getControlIdentifier() {
		return this.controlIdentifier;
	}

	public void setControlIdentifier(String controlIdentifier) {
		this.controlIdentifier = controlIdentifier;
	}

	public String getBatchControlIdentifier() {
		return this.batchControlIdentifier;
	}

	public void setBatchControlIdentifier(String batchControlIdentifier) {
		this.batchControlIdentifier = batchControlIdentifier;
	}

	public MessageType getType() {
		return this.type;
	}

	public void setType(MessageType type) {
		this.type = type;
	}

	public Date getTransmissionDate() {
		return this.transmissionDate;
	}

	public void setTransmissionDate(Date transmissionDate) {
		this.transmissionDate = transmissionDate;
	}

	public MessageStatus getStatus() {
		return this.status;
	}

	public void setStatus(MessageStatus status) {
		this.status = status;
	}

	public Date getAckDate() {
		return this.ackDate;
	}

	public void setAckDate(Date ackDate) {
		this.ackDate = ackDate;
	}

	public AckType getAckType() {
		return this.ackType;
	}

	public void setAckType(AckType ackType) {
		this.ackType = ackType;
	}

	public String getErrorText() {
		return this.errorText;
	}

	public void setErrorText(String errorText) {
		this.errorText = errorText;
	}

	public String getInternalErrorText() {
		return this.internalErrorText;
	}

	public void setInternalErrorText(String internalErrorText) {
		this.internalErrorText = internalErrorText;
	}

	public VAFacility getVaFacility() {
		return this.vaFacility;
	}

	public void setVaFacility(VAFacility vaFacility) {
		this.vaFacility = vaFacility;
	}

	public int getRetransmissionCount() {
		return this.retransmissionCount;
	}

	public void setRetransmissionCount(int retransmissionCount) {
		this.retransmissionCount = retransmissionCount;
	}

	/**
	 * @return Returns the siteReceivedEligibilityStatus.
	 */
	public String getSiteReceivedEligibilityStatus() {
		return siteReceivedEligibilityStatus;
	}

	/**
	 * @param siteReceivedEligibilityStatus The siteReceivedEligibilityStatus to set.
	 */
	public void setSiteReceivedEligibilityStatus(
			String siteReceivedEligibilityStatus) {
		this.siteReceivedEligibilityStatus = siteReceivedEligibilityStatus;
	}

	/**
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);

		builder.append("controlIdentifier", this.controlIdentifier);
		builder.append("batchControlIdentifier", this.batchControlIdentifier);
		builder.append("type", this.type);
		builder.append("transmissionDate", this.transmissionDate);
		builder.append("status", this.status);
		builder.append("ackDate", this.ackDate);
		builder.append("ackType", this.ackType);
		builder.append("errorText", this.errorText);
		builder.append("retransmissionCount", this.retransmissionCount);
		builder.append("siteReceivedEligibilityStatus", this.siteReceivedEligibilityStatus);
	}
} // End of Message Class