/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes

// Framework classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM).
 * This class represents an NCOA Zip Code Plus 4 No Match Reason.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class ZipPlus4NoMatchReason extends AbstractNamedActiveLookup
{
    private static final long serialVersionUID = -1191952452776188367L;

    /* Blank or Insufficient Address */
    public static final Code CODE_BLANK_OR_INSUFFICIENT_ADDRESS = new Code("B");

    /* Early Warning */
    public static final Code CODE_EARLY_WARNING = new Code("E");

    /* House/Apt Number Mismatch */
    public static final Code CODE_HOUSE_NUMBER_MISMATCH = new Code("H");

    /* No Locality Found */
    public static final Code CODE_NO_LOCALITY_FOUND = new Code("L");

    /* Multiple Matches */
    public static final Code CODE_MULTIPLE_MATCHES = new Code("M");

    /* Street Mismatch */
    public static final Code CODE_STREET_MISMATCH = new Code("S");

    /* Unknown */
    public static final Code CODE_UNKNOWN = new Code("U");

    /* Zip Code Not Correct */
    public static final Code CODE_ZIP_CODE_NOT_CORRECT = new Code("Z");

    /* Code not in NCOA */
    public static final Code CODE_NOT_IN_NCOA = new Code("X");

    /* ZIP + 4 Codes Applied */
    public static final Code CODE_ZIP_PLUS_4_CODES_APPLIED = new Code("A");

    public static class Code extends AbstractCode
    {
        private static final long serialVersionUID = 8944863026307415442L;

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public ZipPlus4NoMatchReason()
    {
        super();
    }
}

