/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes
import java.util.Set;
import java.util.HashSet;

// Library classes
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.Validate;

// Framework classes
import gov.va.med.fw.model.lookup.AbstractLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents a Zip Code.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class ZipCode extends AbstractLookup
{
    private static final long serialVersionUID = -3851192194531956290L;
    
    private String zipCode;
    private State state;
    private County county;
    private Set cities = null;
    private City preferredCity;

    /**
     * Default constructor.
     */
    public ZipCode()
    {
        super();
    }

    public State getState()
    {
        return this.state;
    }

    public void setState(State state)
    {
        this.state = state;
    }

    public String getZipCode()
    {
        return this.zipCode;
    }

    public void setZipCode(String zipCode)
    {
        this.zipCode = zipCode;
    }

    public County getCounty()
    {
        return county;
    }

    public void setCounty(County county)
    {
        this.county = county;
    }

    public City getPreferredCity()
    {
        return preferredCity;
    }

    private void setPreferredCity(City preferredCity)
    {
        this.preferredCity = preferredCity;
    }

    private void setCities(Set cities)
    {
        this.cities = cities;
    }

    public Set getCities()
    {
        if (this.cities == null)
        {
            this.cities = new HashSet();
        }
        return this.cities;
    }

    public void addCity(City city)
    {
        getCities().add(city);
    }

    public void removeCity(City city)
    {
        Validate.notNull(city, "Null City specified.");
        getCities().remove(city);
    }

    public void removeAllCities()
    {
        getCities().clear();
    }

    protected void buildToString(ToStringBuilder builder)
    {
        super.buildToString(builder
            .append("state", this.state)
            .append("county", this.county)
            .append("preferredCity", this.preferredCity)
            .append("cities", this.cities)
            .append("zipCode", this.zipCode));
    }

    protected void finalize() throws Throwable
    {
        super.finalize();
        this.state = null;
        this.zipCode = null;
        this.preferredCity = null;
        this.county = null;
    }

    public String getDescription()
    {
        return getZipCode();
    }
}