/*******************************************************************************
 * Copyright  2005 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * Workflow Case Type.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class WkfCaseType extends AbstractNamedActiveLookup {
    /**
    * An instance of serialVersionUID 
    */
    private static final long serialVersionUID = -3951508226623047397L;

    public static final Code CODE_APPLICATION_EXCEPTION = new Code("AE");   //Application Errors 
    public static final Code CODE_CONSISTENCY_CHECK = new Code("CC");//Consistency Checks
    public static final Code CODE_DEMOGRAPHICS = new Code("DM"); //Demographics, including preferred facility
    public static final Code CODE_DUPLICATE_SPOUSE_DEPENDEDNTS = new Code("DR"); //Duplicate Records (beneficiary, spouse and dependents)
    public static final Code CODE_ENTER_EDIT_ENROLLMENT_APP_DATE = new Code("EAD"); //Enter/Edit Enrollment Application Date   
    public static final Code CODE_ELIGIBILITY_UPDATE = new Code("ELU"); //Eligibility Update 
    public static final Code CODE_ENROLLMENT_OVERRIDE = new Code("ENO"); //Enrollment Override    
    public static final Code CODE_ENROLLMENT_UPDATE = new Code("ENU");  //Enrollment Update
    public static final Code CODE_FINANCIAL_ASSESMENT = new Code("FAE"); //Financial Assessment Editing    
    public static final Code CODE_MILITARY_SERVICE = new Code("MS"); //Military Service Data
    public static final Code CODE_PURPLE_HEART = new Code("PH"); //Purple Heart
    public static final Code CODE_REVIEW_FILE = new Code("RF");  //Review File
    public static final Code CODE_VOA_POW_DISCREPANCY = new Code("VPD"); //VOA POW Discrepancy  
    public static final Code CODE_VETERANS_ONLINE_APPLICATION = new Code("VOA"); //Veteran's Online Application
    public static class Code extends AbstractCode
    {
        /**
       * An instance of serialVersionUID 
       */
      private static final long serialVersionUID = -6573508579952763805L;

      private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public WkfCaseType()
    {
        super();
    }
}
