/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

//Framework Classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

import gov.va.med.esr.common.model.lookup.Capability.Code;

/**
 * Lookup class for WKF Case Status type.
 * 
 * Project: Common
 * @author Ghazenfer Mansoor 
 * @version 1.0
 */
public class WkfCaseStatusType extends AbstractNamedActiveLookup {
    
    private static final long serialVersionUID = 4631563389613296314L;
    
    public static final Code NEW = new Code("23");
    public static final Code ASSIGNED = new Code("49"); 
    public static final Code INPROCESS = new Code("18");
	public static final Code CLOSED = new Code("04");
   
	
    /**
     * Default constructor.
     */
    public WkfCaseStatusType() {
        super();
    }
    
    public static class Code extends AbstractCode {
        private static final long serialVersionUID = -1954382891635967221L;

        private Code(String code) {
            super(code);
        }

        public static Code getByCode(String code) {
            return (Code) getCode(Code.class, code);
        }
    }    
}