/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Feb 24, 2006
 *
 */
package gov.va.med.esr.common.model.lookup;


// Java classes

// Library classes

// Framework classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// EDB Classes

/**
 * @author Yi He
 * @version 1.0
 */
public class WeekOfMonth extends AbstractNamedActiveLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 6228022566974472688L;	                                            

	public static final Code FIRST = new Code("1","#1");
	public static final Code SECOND = new Code("2","#2");
	public static final Code THIRD = new Code("3","#3");
	public static final Code FOURTH = new Code("4","#4");
	public static final Code LAST = new Code("5","L");
	
    public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -6194796408658940474L;	                                            
		
		private Code(String code, String alias ) {
			super(code,alias);
		}
      
		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}	
    
    public WeekOfMonth() {
    	super();
    }
}