/*******************************************************************************
 * Copyright  2005 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class
 * represents the different codes for Veterans Choice Eligibility.
 * 
 * @author Andrew Pach
 * @version 3.0
 */
public class WaitType extends AbstractNamedActiveLookup {

	/**
	 * 
	 */
	private static final long serialVersionUID = -5314415013573655050L;

	public static final Code CODE_ELECTRONIC_WAIT_LIST = new Code("EWL");

	public static final Code CODE_VETERANS_CHOICE_LIST = new Code("VCL");

	public static final Code CODE_CONSULT = new Code("CON");


	public static class Code extends AbstractCode {

		/**
		 * 
		 */
		private static final long serialVersionUID = -1155158505860960388L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public WaitType() {
		super();
	}
}
