/*******************************************************************************
 * Copyright  2005 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class
 * represents the different codes for Veterans Choice Eligibility.
 * 
 * @author Sridhar Rao
 * @version 3.0
 */
public class VceStatusType extends AbstractNamedActiveLookup {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -3450342936539560728L;

	public static final Code CODE_BASIC_ELIGIBILITY = new Code("B");

	public static final Code CODE_MILEAGE_ELIGIBILITY = new Code("M");

	public static final Code CODE_WAITTIME_ELIGIBILITY = new Code("WT");

	public static final Code CODE_HARDSHIP_ELIGIBILITY = new Code("H");

	public static final Code CODE_MILEAGE_WAITTIME_ELIGIBILITY = new Code("MWT");

	public static final Code CODE_HARDSHIP_WAITTIME_ELIGIBILITY = new Code("HWT");

    public static final Code CODE_NON_ELIGIBILITY = new Code("X");

	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -7030401854153645941L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public VceStatusType() {
		super();
	}
}
