/**
 * 
 */
package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedLookup;



/**
 * @author DNS   TSAIG
 *
 */
public class VOAFormType extends AbstractNamedLookup {

	private static final long serialVersionUID = 4589531620365442816L;
	
	public static final Code  VOA_FORM_1010EZ = new Code("100");
	public static final Code  VOA_FORM_1010EZR  = new Code("101");
	public static final Code  VOA_FORM_1010HS = new Code("102");
	public static final Code  VOA_FORM_1010SH  = new Code("103");
	public static final Code  VOA_FORM_1010CG = new Code("104");
	public static final Code  VOA_FORM_21526EZ = new Code("105");  //CCR13857 - new form type 21526EZ
	
	public static class Code extends AbstractCode
	{

		private static final long serialVersionUID = -860150451071235851L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);		
		}
	}
	
	
	 /**
	  * Default constructor.
	  */
	public VOAFormType() {
		super();
	}
}
