/**
 * 
 */
package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;



/**
 * @author DNS   TSAIG
 *
 */
public class VOAApplicationStatus extends AbstractNamedActiveLookup {

	private static final long serialVersionUID = 4589531620365442816L;
	
	public static final Code  FORM_SUBMITTED = new Code("100");
	public static final Code  FORM_SUBMISSION_FAILED = new Code("101");
	public static final Code  FORM_PROCESSING_IN_PROGRESS = new Code("102");
	public static final Code  FORM_PROCESSING_PENDING = new Code("103");
	public static final Code  FORM_PROCESSED_SUCCESSFUL = new Code("104");
	public static final Code  FORM_RESUBMITTED = new Code("105");
	
	public static class Code extends AbstractCode
	{

		private static final long serialVersionUID = -860150451071235851L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);		
		}
	}
	
	
	 /**
	  * Default constructor.
	  */
	public VOAApplicationStatus() {
		super();
	}
}
