/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes

// ESR classes
import java.lang.reflect.Method;
import java.math.BigDecimal;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

/**
 *
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class VISN extends AbstractNamedActiveLookup
{
	private static final long serialVersionUID = -7626834010311202170L;

    public static final Code CODE_NO_VISN = new Code("No VISN");	
	
	public static final BigDecimal CODE_NO_VISN_IDENTIFIER = new BigDecimal(-1); 
    
    public static class Code extends AbstractCode
    {
        private static final long serialVersionUID = 5798557687826281792L;

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }
    
    public VISN() {
        super();
    };
    
    private VAFacilityType type = null;
    
    public VAFacilityType getType()
    {
        return type;
    }

    public void setType(VAFacilityType type)
    {
        this.type = type;
    }
    
    public String getFacilityName() {
        return getName() != null ? getName() : getDescription();
    }
    
    public static VISN getNoVISN()
    {
    	VISN visn = new VISN();
    	
    	visn.setName(CODE_NO_VISN.getName());
    	visn.setDescription(CODE_NO_VISN.getName());
    	
    	
		try {			
			Class abstractKeyedEntity = Class.forName("gov.va.med.fw.model.lookup.AbstractLookup");
			final Method[] methods = abstractKeyedEntity.getDeclaredMethods();
			for (int i=0; i<methods.length; i++)
			{
				if (methods[i].getName().equals("setIdentifier"))
				{
					final Object params[] = new Object[1];
					params[0] = CODE_NO_VISN_IDENTIFIER;
					methods[i].setAccessible(true);
					methods[i].invoke(visn,params);
				}
				
				if (methods[i].getName().equals("setCode"))
				{
					final Object params[] = new Object[1];
					params[0] = CODE_NO_VISN.getCode();
					methods[i].setAccessible(true);
					methods[i].invoke(visn,params);
				}
				
			}
		}
		catch (Exception e) {
			throw new RuntimeException("Exception setting Identifier for No VISN ",e);
		}
    	
    	return visn;
    }
}

