/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents a VA Facility.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class VAFacilityType extends AbstractNamedActiveLookup
{
    private static final long serialVersionUID = -5355454109492023060L;

    /* VAMC Code */
    public static final Code CODE_VAMC = new Code("VAMC");

    /* VISN Code */
    public static final Code CODE_VISN = new Code("VISN");

    /* Health Care System */
    public static final Code CODE_HCS = new Code("HCS");
    
    /* Regional Office */
    public static final Code CODE_RO = new Code("RO");
    
    /* Regional Office and Insurance Center*/
    public static final Code CODE_ROANDIC = new Code("RO&IC");
    
    /* Regional Office Outpatient Clinic*/
    public static final Code CODE_RO_OC = new Code("RO-OC");
    
    /* Record Processing Center*/
    public static final Code CODE_RPC = new Code("RPC");
    
    /*  Medical and Regional Office Center */
    public static final Code CODE_MROC = new Code("M&ROC");
    
    //Prefered Facilities 
    public static final Code CODE_CBOC = new Code("CBOC");
    public static final Code CODE_MCMD = new Code("MC(M&D)");
    public static final Code CODE_MCM = new Code("MC(M)");
    public static final Code CODE_MORC = new Code("MORC");
    public static final Code CODE_OC = new Code("OC");
    public static final Code CODE_OCMC = new Code("OCMC");
    public static final Code CODE_OCS = new Code("OCS");
    public static final Code CODE_OPC = new Code("OPC");
    public static final Code CODE_ORC = new Code("ORC");
    public static final Code CODE_SOC = new Code("SOC");
    public static final Code CODE_HEALTHCARE = new Code("HEALTHCARE");
    public static final Code CODE_MROC_MRO = new Code("M&ROC(M&RO)");
    public static final Code CODE_MOC = new Code("MOC");
    public static final Code CODE_NETWORK = new Code("NETWORK");
    public static final Code CODE_SATELLITE = new Code("SATELLITE");
    public static final Code CODE_VA_ROSEBURG = new Code("VA ROSEBURG");

    public static class Code extends AbstractCode
    {
        private static final long serialVersionUID = 74145293624910535L;

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }
    
    private boolean isMedicalTreating;

    /**
     * Default constructor.
     */
    public VAFacilityType()
    {
        super();
    }

	/**
	 * @return Returns the isMedicalTreating.
	 */
	public boolean getIsMedicalTreating() {
		return isMedicalTreating;
	}

	/**
	 * @param isMedicalTreating The isMedicalTreating to set.
	 */
	public void setIsMedicalTreating(boolean isMedicalTreating) {
		this.isMedicalTreating = isMedicalTreating;
	}

}
