package gov.va.med.esr.common.model.lookup;

// Java classes
import java.io.Serializable;
import java.math.BigDecimal;

// Library classes

// Framework classes
import org.springframework.beans.factory.config.MethodInvokingFactoryBean;
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;
import gov.va.med.fw.util.StringUtils;

/**
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class VAFacility extends AbstractNamedActiveLookup
{
    private static final long serialVersionUID = 922875941730007979L;

    /** Albuquerque Champ VA */
	public static final Code CODE_ALBUQUERQUE = new Code("724");


    /** Health Eligibility Center Code */
    public static final Code CODE_HEC = new Code("742");

    /** Incorrect code Health Eligibility Center Code that all Vista sites are using.  This must be preserved until sites comply */
    public static final Code CODE_HEC_INCORRECT = CODE_ALBUQUERQUE;

    /** Code for MVR/AAC/VBA */
    public static final Code CODE_MVR = new Code("200");

    /** Connecticut HCS Code */
    public static final Code CODE_CONNECTICUT_HCS = new Code("689");

    /** New Bedford CBOC Code */
    public static final Code CODE_NEW_BEDFORD_CBOC = new Code("650GA");

    /** Michael E. Debakey VA Medical Center Code */
    public static final Code CODE_MICHAEL_E_DEBAKEY_VA_MEDICAL_CENTER = new Code("580");

    /** Iron Mountain VA Medical Center Code */
    public static final Code CODE_IRON_MOUNTAIN_VA_MEDICAL_CENTER = new Code("585");

    /** Default Claim Folder Location */
    public static final Code CODE_DEFAULT_CLAIM_FOLDER_LOCATION = new Code("376");

    /**MPI (Master Patient Index) TRIGGER 200M */
    public static final Code CODE_MPI_TRIGGER = new Code("200M");

    /**MHV (VOA) voa site**/
    //CCR12216 make 200MH configurable by injecting it from business_services.xml - workaround for Spring injection to static variable
    //can't use final anymore because static data field is loaded before static method :-(
    public static Code CODE_MHV;

    //CCR12216 inject 200MH from business_services.xml
	public static void setVoaStationNumber(String stationNumber) {
	    CODE_MHV = new Code(stationNumber);
	}

    public static class Code extends AbstractCode
    {
        private static final long serialVersionUID = 9209295537751778591L;

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    public static final String QUERY_FIND_ALL_MFNZEG_RECIPIENTS = "vaFacilityQuery_FindAllMfnzegRecipients";
    public static final String QUERY_FIND_ALL_DEATH_NOTIFICATION_SITES = "vaFacilityQuery_FindAllDeathNotificationSites";
    public static final String QUERY_FIND_ALL_DEATH_NOTIFICATION_SITES_NCA = "vaFacilityQuery_FindAllDeathNotificationSites_NCA";

    private String stationNumber;
    private VAFacilityType type;
    private VAFacilityAddress  address = null;
    private BigDecimal visnId;
    private BigDecimal parentId;
    private Boolean mfnzegRecipient = null;
    private String emailDomainName = null;

    //special errorReason for CLEAR extract import to pass the
    //error reason for detail unsuccessful report - no other place to put it but here :-(
    private String errorReason = null;

    /**
     * Default constructor.
     */
    public VAFacility()
    {
        super();
    }

    public VAFacilityType getType()
    {
        return type;
    }

    public void setType(VAFacilityType type)
    {
        this.type = type;
    }

    public String getStationNumber()
    {
        return stationNumber;
    }

    public void setStationNumber(String stationNumber)
    {
        this.stationNumber = stationNumber;
    }

    public VAFacilityAddress getStreetAddress() {
        return this.address;
    }

    public void setStreetAddress(VAFacilityAddress address) {
        this.address = address;
    }

    public String getFacilityName() {
        return getStationNumber() == null ? getDescription() :
            getDescription() + " (#" + getStationNumber() + ")";
    }

    public BigDecimal getVisnId() {
        return visnId;
    }

    public void setVisnId(BigDecimal visnId) {
        this.visnId = visnId;
    }

    public static class VAFacilityAddress implements Serializable {
        private static final long serialVersionUID = 237630687409244815L;

        private String line1;
        private String line2;
        private String line3;
        private String city;
        private String zipCode;
        private State state;

        public VAFacilityAddress() {
        	super();
        }

        public String getLine1() {
            return this.line1;
        }

        // Hibernate use only
        private void setLine1(String line1) {
            this.line1 = line1;
        }

        public String getLine2() {
            return this.line2;
        }

        private void setLine2(String line2) {
            this.line2 = line2;
        }

        public String getLine3() {
            return this.line3;
        }

        private void setLine3(String line3) {
            this.line3 = line3;
        }

        public String getCity() {
            return this.city;
        }

        private void setCity(String city) {
            this.city = city;
        }

        public String getZipCode() {
            return this.zipCode;
        }

        private void setZipCode(String zipCode) {
            this.zipCode = zipCode;
        }

        public State getState() {
            return this.state;
        }

        private void setState(State state) {
            this.state = state;
        }
    }

	public BigDecimal getParentId() {
		return parentId;
	}

	public void setParentId(BigDecimal parentId) {
		this.parentId = parentId;
	}

    public Boolean getMfnzegRecipient()
    {
        return mfnzegRecipient;
    }

    public Boolean isMfnzegRecipient()
    {
        return mfnzegRecipient;
    }

    public void setMfnzegRecipient(Boolean mfnzegRecipient)
    {
        this.mfnzegRecipient = mfnzegRecipient;
    }

	public String getEmailDomainName() {
		return emailDomainName;
	}

	public void setEmailDomainName(String domainName) {
		this.emailDomainName = domainName;
	}

    /**
     * Returns the station number plus the description.
     * @return the site number and name.
     */
    public String getSiteNumberAndName()
    {
        StringBuffer buffer = new StringBuffer();
        if (StringUtils.isNotEmpty(getCode()))
        {
            buffer.append(getCode());
        }
        if (StringUtils.isNotEmpty(getDescription()))
        {
            if (buffer.length() > 0)
            {
                buffer.append(" - ");
            }
            buffer.append(getDescription());
        }
        return buffer.toString();
    }

	public String getErrorReason() {
		return errorReason;
	}

	public void setErrorReason(String errorReason) {
		this.errorReason = errorReason;
	}
}
