/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Framework classes
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;

/**
 * Transaction type for history events.
 * Modified to return the predfeined type codes 
 * @author DNS   MANSOG
 * @date Jun 13, 2005 4:23:17 PM
 */
public class TransactionType extends AbstractNamedActiveLookup {
	
    private static final long serialVersionUID = -7620439254254633591L;
    
    public static final Code CODE_INSERT = new Code(gov.va.med.fw.model.lookup.TransactionType.CODE_INSERT.getCode());
    public static final Code CODE_UPDATE = new Code(gov.va.med.fw.model.lookup.TransactionType.CODE_UPDATE.getCode());
    public static final Code CODE_DELETE = new Code(gov.va.med.fw.model.lookup.TransactionType.CODE_DELETE.getCode());

	public static class Code extends AbstractCode {
		private static final long serialVersionUID = 99554460612580929L;

        private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}    

    /**
     * Default Constructor
     */
    public TransactionType() {
        super();
    }
   
    public boolean isDeleted() {
    	return CODE_DELETE.getName().equals(getCode()); }
    
    public boolean isUpdated() {
    	return CODE_UPDATE.getName().equals(getCode()); }
    
    public boolean isInserted() {
    	return CODE_INSERT.getName().equals(getCode()); }
   
    public static TransactionType getTransactionTypeByCode(Code code) {
        TransactionType transactionType = new TransactionType ();
        //set the type code
        // valid lookup, construct shell object
       try {
           Method method = TransactionType.class.getDeclaredMethod("setCode",
                   new Class[] { String.class });
           method.setAccessible(true);
           method.invoke(transactionType, new Object[] { code.getName() });
       } catch (Exception e) {
           throw new RuntimeException("Unable to create TransactionType", e);
       }
       return transactionType;
    }
   
    public static List getAllTransactionTypes() throws UnknownLookupTypeException,
        UnknownLookupCodeException {
        // TODO: provide support at the database layer for this.  For now, just return the appropriate object
   		List types = new ArrayList(3);
   		types.add(getTransactionTypeByCode(CODE_INSERT));
   		types.add(getTransactionTypeByCode(CODE_UPDATE));
   		types.add(getTransactionTypeByCode(CODE_DELETE));
   		return types;
    }
}