/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

public class SystemParameterUnit extends AbstractNamedActiveLookup {
    
    private static final long serialVersionUID = 7066882202119192984L;
    
    public static final Code CODE_HOURS = new Code("1");
    public static final Code CODE_DAYS = new Code("2");
    public static final Code CODE_WEEKS = new Code("3");
    public static final Code CODE_MONTHS = new Code("4");
    public static final Code CODE_COUNT = new Code("5");

    
    public SystemParameterUnit() {
        super();
    }
    
    public static class Code extends AbstractCode {
 
        private static final long serialVersionUID = -35988780476532304L;

        private Code(String code) {
            super(code);
        }

        public static Code getByCode(String code) {
            return (Code) getCode(Code.class, code);
        }
    }
}
