/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

public class SystemParameterType extends AbstractNamedActiveLookup {

    private static final long serialVersionUID = -6803569015557056798L;

    /* Nemeric */
    public static final Code CODE_NUMERIC = new Code("1");
    /* AlphaNumeric */
    public static final Code CODE_ALPHANUMERIC = new Code("2"); 

    public SystemParameterType() {
        super();
    }
    
    public static class Code extends AbstractCode {
        private static final long serialVersionUID = -7442343721638482068L;

        private Code(String code) {
            super(code);
        }

        public static Code getByCode(String code) {
            return (Code) getCode(Code.class, code);
        }
    }
}
