package gov.va.med.esr.common.model.lookup;

// Library Classes
import org.apache.commons.lang.builder.ToStringBuilder;

// Framework Classes
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

/**
 * The State class.
 */
public class State extends AbstractNamedActiveLookup
{
    private static final long serialVersionUID = 1209819135619623706L;

    private Country country;

    private String fipsCode;

    private String postalName;

    /**
     * Default constructor.
     */
    public State()
    {
        super();
    }

    /**
     * Returns the country for this state.
     *
     * @return The country for this state.
     */
    public Country getCountry()
    {
        return this.country;
    }

    /**
     * Sets the country for this state.
     *
     * @param country The country for this state.
     */
    private void setCountry(Country country)
    {
        this.country = country;
    }

    /**
     * Returns the unique FIPS code for this state.
     *
     * @return The unique FIPS code for this state.
     */
    public String getFipsCode()
    {
        return this.fipsCode;
    }

    /**
     * Sets the unique FIPS code for this state.
     *
     * @param fipsCode The unique FIPS code for this state.
     */
    private void setFipsCode(String fipsCode)
    {
        this.fipsCode = fipsCode;
    }

    /**
     * Returns the unique USPS name for this state.
     *
     * @return The unique USPS name for this state.
     */
    public String getPostalName()
    {
        return this.postalName;
    }

    /**
     * Sets the unique USPS name for this state.
     *
     * @param postalName The unique USPS name for this state.
     */
    private void setPostalName(String postalName)
    {
        this.postalName = postalName;
    }

    public void setName(String name)
    {
        if (name != null)
        {
            name = name.toUpperCase();
        }
        super.setName(name);
    }

    public void setDescription(String description)
    {
        if (description != null)
        {
            description = description.toUpperCase();
        }
        super.setDescription(description);
    }

    /**
     * Gets the description by returning the name.
     */
    public String getDescription()
    {
        return getName();
	}

    /**
     * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder)
    {
        super.buildToString(builder
            .append("country", this.country)
            .append("fipsCode", this.fipsCode)
            .append("postalName", this.postalName));
    }

    /**
     * @see java.lang.Object#finalize()
     */
    protected void finalize() throws Throwable
    {
        super.finalize();

        this.country = null;
        this.fipsCode = null;
        this.postalName = null;
    }
}