package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

/**
 * 
 * @author DNS   ruizc
 * @version 1.0
 *
 */
public class SpecialOperation extends AbstractNamedActiveLookup {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -1699671416562949962L;
	
	public static final Code NOT_APPLICABLE = new Code("00");
	public static final Code OPERATION_DESERT_STORM = new Code("01");
	public static final Code LOS_ANGELES_RIOTS = new Code("02");
	public static final Code HAITI = new Code("03");
	public static final Code SOMALIA = new Code("04");
	public static final Code BOSNIA = new Code("05");
	public static final Code KOSOVO = new Code("06");
	public static final Code OPERATION_SOUTHERN_WATCH = new Code("07");
	public static final Code OPERATION_NOBLE_EAGLE = new Code("08");
	public static final Code OPERATION_ENDURING_FREEDOM = new Code("09");
	public static final Code OPERATION_IRAQI_FREEDOM = new Code("10");
	public static final Code HURRICANE_KATRINA_9GY_OPERATIONS = new Code("11");
	public static final Code HURRICANE_WILMA_OPERATIONS = new Code("12");
	public static final Code PAKISTAN_EARTHQUAKE_OPERATIONS = new Code("13");
	public static final Code NOT_A_SPECIAL_OPERATION = new Code("98");
	public static final Code OTHER = new Code("99");	
	
	
	public static class Code extends AbstractCode
	{
		/**
		 * 
		 */
		private static final long serialVersionUID = -5332710079848418101L;

		/**
		 * 
		 */
		private Code(String code)
		{
			super(code);
		}

		public static Code getByCode(String code)
		{
			return (Code)getCode(Code.class, code);
		}
	}	
	
	/**
	 * Default Constructor 
	 */
	public SpecialOperation() {
		super();
	}
}
