/*******************************************************************************
 * Copyright  2005 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

public class SourceDesignation extends AbstractNamedActiveLookup {
	/**
	 * 
	 */

	/**
	 * 
	 */
	private static final long serialVersionUID = 0L;

	/**
	 * An instance of serialVersionUID
	 */

	/* PCP Active Code */
	public static final Code CODE_PCP_ACTIVE = new Code("PA");
	
	/* PCP Inactive Code */
	public static final Code CODE_PCP_INACTIVE = new Code("PI");
	
	/* VistA Code */
	public static final Code CODE_VISTA = new Code("V");

	/* ESR Code */
	public static final Code CODE_ESR = new Code("E");
	

	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public SourceDesignation() {
		super();
	}
}
