/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Jan 5, 2006
 *
 */
package gov.va.med.esr.common.model.lookup;


// Java classes

// Library classes

// Framework classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// EDB Classes

/**
 * @author Yi He
 * @version 1.0
 */
public class SignatureIndicator extends AbstractNamedActiveLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -8919645243757277969L;	                                            
	
	public static final Code CODE_NO = new Code("0");
	public static final Code CODE_YES = new Code("1");	
	//public static final Code CODE_DELETED = new Code("9");
	public static final Code CODE_ERROR = new Code("9");
		
	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 1109690054472596730L;	                                            
		
		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}
	
	public SignatureIndicator() {
		super();
	}
}

