/*******************************************************************************
 * Copyright  2005 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class
 * represents a Service Branch.
 * 
 * @author Andrew Pach
 * @version 3.0
 */
public class ServiceBranch extends AbstractNamedActiveLookup {
	private static final long serialVersionUID = -2339865653992491788L;

    /* Army Code */
	public static final Code CODE_ARMY = new Code("1");

	/* Air Force Code */
	public static final Code CODE_AIR_FORCE = new Code("2");

	/* Navy Code */
	public static final Code CODE_NAVY = new Code("3");

	/* Marine Corps Code */
	public static final Code CODE_MARINE_CORPS = new Code("4");

	/* Coast Guard Code */
	public static final Code CODE_COAST_GUARD = new Code("5");

	/* Other Code */
	public static final Code CODE_OTHER = new Code("6");

	/* Merchant Seaman Code */
	public static final Code CODE_MERCHANT_SEAMAN = new Code("7");

	/* B.E.C. Code */
	public static final Code CODE_BEC = new Code("8");

	/* USPHS Code */
	public static final Code CODE_USPHS = new Code("9");

	/* NOAA Code */
	public static final Code CODE_NOAA = new Code("10");

	/* F.COMMONWEALTH Code */
	public static final Code CODE_F_COMMONWEALTH = new Code("11");

	/* F.GUERILLA Code */
	public static final Code CODE_F_GUERILLA = new Code("12");

	/* F.SCOUTS NEW Code */
	public static final Code CODE_F_SCOUTS_NEW = new Code("13");

	/* F.SCOUTS OLD Code */
	public static final Code CODE_F_SCOUTS_OLD = new Code("14");

	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 1L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public ServiceBranch() {
		super();
	}
}