/*
 * Created on Oct 27, 2005
 *
 */
package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

/**
 * @author Yi He
 *
 */
public class SensitivityChangeSource extends AbstractNamedActiveLookup {

	private static final long serialVersionUID = -2655605636633626773L;

    /* HEC - Health Eligibility Center Code */
	public static final Code CODE_HEC = new Code("1");

	/* VAMC - Veterans Affairs Medical Center Code */
	public static final Code CODE_VAMC = new Code("3");

	/* VBA */
	public static final Code CODE_VBA = new Code("2");
	
	/**
	 * 
	 */
	public SensitivityChangeSource() {
		super();
	}

	public static class Code extends AbstractCode {

		private static final long serialVersionUID = -2581674781023947691L;

        private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}
}
