/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents an SSN Type.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class SSNType extends AbstractNamedActiveLookup
{
    private static final long serialVersionUID = -704025386085536005L;

    /* Official Code */
    public static final Code CODE_ACTIVE = new Code("ACTIVE");

    /* Other Code */
    public static final Code CODE_ALIAS = new Code("ALIAS");

    /* Pseudo Code */
    public static final Code CODE_PSEUDO = new Code("PSEUDO");

    public static class Code extends AbstractCode
    {
        private static final long serialVersionUID = 7663714424780457035L;

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public SSNType()
    {
        super();
    }
}
