/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

/**
 * SSA Verification Code lookup
 * 
 * @author DNS   MANSOG
 * @date Jun 17, 2005 4:23:17 PM
 */
public class SSAVerificationStatus
    extends AbstractNamedActiveLookup {
	
	private static final long serialVersionUID = 4397333869589334429L;
    public static final Code NEW_RECORD = new Code("0");
	public static final Code VERIFIED = new Code("4");
	public static final Code INVALID_PER_SSA = new Code("2");
	public static final Code RESEND_TO_SSA = new Code("3");
	public static final Code IN_PROCESS = new Code("1");
	
	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 641469652092111868L;
		private Code(String code) {	super(code); }
		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}	
	

    /**
     * Default Constructor
     */
    public SSAVerificationStatus() {
        super();
    }
}