/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

import gov.va.med.esr.common.model.lookup.SSAVerificationStatus.Code;
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

/**
 * SSA Message lookup
 * 
 * @author DNS   MANSOG
 * @date Jul 20, 2005 5:31 PM
 */
public class SSAMessage
    extends AbstractNamedActiveLookup {

    private static final long serialVersionUID = 7125040886352043463L;

    /**
     * Default Constructor
     */
    public SSAMessage() {
        super();
    }
    
	public static final Code SSN_NOT_ON_FILE = new Code("1");
	public static final Code NAME_DOB_MATCH_NOT_SEX = new Code("2");
	public static final Code NAME_SEX_MATCH_NOT_DOB = new Code("3");
	public static final Code NAME_MATCH_NOT_DOB_SEX = new Code("4");
	public static final Code NAME_DOES_NOT_MATCH_DOB_SEX_NOT_CHECKED = new Code("5");
	
	public static final Code DIFFERENT_SSN_LOCATED = new Code("6");
	public static final Code DIFFERENT_SSN_LOCATED_A = new Code("A");
	public static final Code DIFFERENT_SSN_LOCATED_B = new Code("B");
	
	public static final Code MULTIPLE_SSNS_LOCATED_C = new Code("C");
	public static final Code MULTIPLE_SSNS_LOCATED_D = new Code("D");
	
	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 641469652092111868L;
		private Code(String code) {	super(code); }
		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}	
	
}