/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Feb 23, 2006
 *
 */
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes

// Framework classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// EDB Classes

/**
 * @author Yi He
 * @version 1.0
 */
public class ReportWorkItemStatus extends AbstractNamedActiveLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -756737889975098062L;	                                            

	public static final Code NEW = new Code("1");
	public static final Code IN_PROCESS = new Code("2");
	public static final Code BOTH_NEW_AND_IN_PROCESS = new Code("3");
	public static final Code CLOSED = new Code("4");
	
    public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 8643118825386789663L;	                                            
		
		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}	
    
    public ReportWorkItemStatus() {
    	super();
    }
}



