/********************************************************************
 * Copyright � 2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Feb 23, 2006
 *
 */
package gov.va.med.esr.common.model.lookup;

// Java classes
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

// Library classes

// Framework classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// EDB Classes

/**
 * @author Yi He
 * @version 1.0
 */
public class ReportType extends AbstractNamedActiveLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -8625928737986078349L;

    private static Comparator reportTypeNameComparator = new ReportTypeNameComparator();

	public static final Code ENROLLMENT = new Code("1");
	public static final Code CANCEL_DECLINE = new Code("2");
	public static final Code FINANCIAL = new Code("3");
	public static final Code ADDRESS = new Code("4");
	public static final Code SSN = new Code("5");
	public static final Code MST = new Code("6");
	public static final Code WORKLOAD = new Code("7");
	public static final Code CORRESPONDENCE = new Code("8");
	public static final Code QUALITY_MANAGEMENT = new Code("9");
	public static final Code INSURANCE = new Code("10");
	public static final Code MESSAGING = new Code("11");
	public static final Code DUPLICATE_MERGE = new Code("12");
	public static final Code PH = new Code("13");
	public static final Code OPP = new Code("14");
	public static final Code BULK_REGISTRY_LOAD = new Code("15");

	public static final Code CLEAR = new Code("22");
	public static final Code ACA = new Code("23");

    // TODO make it protected
    public ReportType() {
        super();
    }

	public Set getCapabilities() {
		return Collections.unmodifiableSet(getInternalCapabilities());
	}

	private Set getInternalCapabilities() {
		if (this.internalCapabilities == null) {
			this.internalCapabilities = new HashSet();
		}
		return this.internalCapabilities;
	}

	/**
	 * Setter - for hibernate use only.
	 *
	 */
	private void setInternalCapabilities(Set capabilities) {
		this.internalCapabilities = capabilities;
	}

	/**
	 *
	 * @return
	 */
	public String getScheduleRunPermissionCode()
	{
		Set capabilities=getCapabilities();
		if(capabilities!=null)
		{
			for (Iterator it=capabilities.iterator();it.hasNext();)
			{
				String code=(String)((Capability) it.next()).getCode();
            	if(Capability.SCHEDULE_RUN_REPORTS.indexOf(code)!=-1)
            	{
	                return code;
            	}
			}
		}
		return "";
	}

	// Capabilities needed to access reports of this type
	private Set internalCapabilities;

    public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 1070366203677925725L;

		private Code(String code) {
			super(code);
		}



		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}

	}

    public static Comparator getReportTypeNameComparator() {
        return reportTypeNameComparator;
    }
}

class ReportTypeNameComparator implements Comparator, Serializable {

    private static final long serialVersionUID = 6562479937547812959L;

    public int compare(Object pObject1, Object pObject2)
    {
        String name1 = (pObject1 != null && pObject1 instanceof ReportType) ?
            ((ReportType)pObject1).getDescription() : null;
        String name2 = (pObject2 != null && pObject2 instanceof ReportType) ?
            ((ReportType)pObject2).getDescription() : null;
        return (name1 != null && name2 != null) ? name1.compareTo(name2) : 0;
    }
}

