/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Feb 23, 2006
 *
 */
package gov.va.med.esr.common.model.lookup;


// Java classes

// Library classes

// Framework classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// EDB Classes

/**
 * @author Yi He
 * @version 1.0
 */
public class ReportPeriodType extends AbstractNamedActiveLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -2036383769934731768L;	                                            

    public static final Code CODE_FISCAL_YEAR = new Code("1");
    public static final Code CODE_ALL_FISCAL_YEARS = new Code("2");
    public static final Code CODE_QUARTERLY = new Code("3");
    public static final Code CODE_DATE_RANGE = new Code("4");
    	
    public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -7710330151299006504L;	                                            
		
		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}	
    
    public ReportPeriodType() {
    	super();
    }
}

