/*******************************************************************************
 * Copyright  2006 VHA. All rights reserved
 ******************************************************************************/

/*
 * Created on Feb 23, 2006
 */
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes

// Framework classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// EDB Classes

/**
 * @author Yi He
 * @version 1.0
 */
public class ReportFormat extends AbstractNamedActiveLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -8324961336832941892L;

	public static final Code USER = new Code("3");
	public static final Code DETAIL = new Code("2");
	public static final Code SUMMARY = new Code("1");
	
	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 2871895184008159232L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}
	
    // TODO: change this to protected after lookup tables are created
	public ReportFormat() {
		super();
	}
}
