/*******************************************************************************
 * Copyright  2006 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class
 * represents an Enrollment status components for reports.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class ReportEnrollmentStatus extends AbstractNamedActiveLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -1678691037959197615L;

	/* Query Sent to VBA Code */
	public static final Code CODE_QUERY_SENT_TO_VBA = new Code("1");

	/* Query Returned to VBA Code */
	public static final Code CODE_QUERY_RETURNED_TO_VBA = new Code("2");

	/* Eligibility Verified Code */
	public static final Code CODE_ELIGIBILITY_VERIFIED = new Code("3");

	/* Enrollment Created Code */
	public static final Code CODE_ENROLLMENT_CREATED = new Code("4");

	/* Message Accepted at Site Code */
	public static final Code CODE_MESSAGE_ACCEPTED_AT_SITE = new Code("5");

	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -6852121223703591884L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public  ReportEnrollmentStatus()
    {
		super();
	}
}
